/**
 * Memory Analyser  version 1.00
 * Copyright (c) 2018, Tycho Veltmeijer.
 * All rights reserved.
**/

#include "memory_analyser.h"
#include "list.h"

DUMP_SESSION* InitiateIEFilter1(char* location, char* argument, int analyse_type);
DUMP_SESSION* InitiateIEFilter2(char* location, char* argument, int analyse_type);
DUMP_SESSION* InitiateIEFilter3(char* location, char* argument, int analyse_type);

int ApplyIEFilter1(DUMP_SESSION* dmp, HANDLE process, MEMORY_BASIC_INFORMATION* memInfo, char* buff, SIZE_T overflowSize);
int ApplyIEFilter2(DUMP_SESSION* dmp, HANDLE process, MEMORY_BASIC_INFORMATION* memInfo, char* buff, SIZE_T overflowSize);
int ApplyIEFilter3(DUMP_SESSION* dmp, HANDLE process, MEMORY_BASIC_INFORMATION* memInfo, char* buff, SIZE_T overflowSize);

void DestroyIEFilter1(DUMP_SESSION* filter);
void DestroyIEFilter2(DUMP_SESSION* filter);
void DestroyIEFilter3(DUMP_SESSION* filter);

void* findPointerInMemory(void* list, void* PVP, MEMORY_BASIC_INFORMATION** retMemInfo, MEMORY_BASIC_INFORMATION* memOffset, void* offset, int flags);
void* ProcessVirtualPointerToVP(void* list, void* PVP);

#define MODE_32_BIT 0x1
#define MODE_VOID_BIT 0x0